<#ibiztemplate>
TARGET=PSAPPDELOGIC
</#ibiztemplate>
<#if item.getPSDELogicNodes()??>
    <#list item.getPSDELogicNodes() as delogicNode>
         <#if delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "DEACTION">
            <#if delogicNode.getDstPSAppDataEntity()?? && delogicNode.getDstPSAppDEAction()??>
            <#assign targetEntity = delogicNode.getDstPSAppDataEntity() />
                <#if !P.exists("importService", targetEntity.getId(), "")>
import ${srfclassname('${targetEntity.getCodeName()}')}Service from '@/service/${srffilepath2(targetEntity.getCodeName())}/${srffilepath2(targetEntity.getCodeName())}-service';
                </#if>
            </#if>
         </#if>
    </#list>
</#if>
import { Verify } from '@/utils/verify/verify';

<#-- 设置参数 -->
<#macro setParam logicNode>
<#if logicNode.getPSDELogicNodeParams()??>
<#list logicNode.getPSDELogicNodeParams() as logicparam>
<#if logicparam.getSrcFieldName()?? && logicparam.getDstFieldName()??>
        Object.assign(params,{${logicparam.getDstFieldName()?lower_case}:<#if logicparam.getSrcFieldName()?? && logicparam.getSrcFieldName() != "">params.${logicparam.getSrcFieldName()?lower_case}<#else>params.${logicparam.getDstFieldName()?lower_case}</#if>});
        <#if logicparam.getDstPSDELogicParam?? && logicparam.getDstPSDELogicParam()?? && logicparam.getDstPSDELogicParam().getParamPSAppDataEntity()??>
        <#if logicparam.getSrcFieldName()?lower_case?contains("id") >
        Object.assign(context,{${logicparam.getDstPSDELogicParam().getParamPSAppDataEntity().getCodeName()?lower_case}:params.${logicparam.getSrcFieldName()?lower_case}});
        </#if>
        </#if>
</#if>
</#list>
</#if>
</#macro>

<#-- 调用下一节点处理逻辑 -->
<#macro executeNext logicNode>
<#if logicNode.getPSDELogicLinks()??>
<#list logicNode.getPSDELogicLinks() as logiclink>
<#if logiclink.getDstPSDELogicNode()??>
<#assign nextnode = logiclink.getDstPSDELogicNode() />
<#list item.getPSDELogicLinks() as curLink >
<#if curLink.getId() == logiclink.getId()>
<#assign curIndex = curLink_index/>
</#if>
</#list>
        if(this.compute${curIndex}Cond(params)){
            return this.execute${nextnode.codeName}(context,params,isloading);   
        }
</#if>
</#list>
<#else>
        return params;
</#if>
</#macro>

<#-- 获取判断条件 -->
<#macro getCond item><#if item.getLogicType() == 'GROUP'><#if item.isNotMode()>!(</#if><#if item.getPSDELogicLinkConds()??><#list item.getPSDELogicLinkConds() as subLogic><#if subLogic_index gt 0><#if item.getGroupOP() == 'AND'> && </#if><#if item.getGroupOP() == 'OR'> || </#if></#if><@getCond subLogic /></#list></#if><#if item.isNotMode()>)</#if><#elseif item.getLogicType() == 'SINGLE'>Verify.testCond(params.${item.getDstFieldName()?lower_case}, '${item.getCondOP()}', '${item.getValue()}')</#if></#macro>

/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}LogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}LogicBase {

    /**
     * 名称
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}LogicBase
     */
    private name:string ="${item.codeName}";

    /**
     * 唯一标识
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}LogicBase
     */
    private id:string = "${item.id}";

    /**
     * 默认参数名称
     * 
     * @memberof  ${srfclassname('${item.getCodeName()}')}LogicBase
     */
    private defaultParamName:string = "${item.getDefaultParamName()}";

    /**
     * Creates an instance of  ${srfclassname('${item.getCodeName()}')}LogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}LogicBase
     */
    constructor(opts: any = {}) {
        
    }

<#if item.getPSDELogicLinks()??>
<#list item.getPSDELogicLinks() as curLink>

    /**
     * 计算${curLink_index}节点结果
     * 
     * @param params 传入参数
     */
    public compute${curLink_index}Cond(params:any):boolean{
    <#if curLink.getPSDELogicLinkGroupCond()??>
        <#assign linkCond = curLink.getPSDELogicLinkGroupCond() />
        if(<@getCond linkCond />){
           return true;
        }else{
            return false;
        }
    <#else>
        return true;
    </#if>  
    }
</#list>
</#if>

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.execute${item.getStartPSDELogicNode().codeName}(context,params,isloading);
    }

<#if item.getPSDELogicNodes()??>
    <#list item.getPSDELogicNodes() as delogicNode>

    <#-- 开始节点 -->
    <#if delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "BEGIN">
    /**
    * ${delogicNode.getName()}
    * 
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        //开始节点
        <@setParam delogicNode />
        <@executeNext delogicNode />
    }
    <#-- 行为处理节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "DEACTION">
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // 行为处理节点
        <@setParam delogicNode  />
        <#if delogicNode.getDstPSAppDataEntity()?? && delogicNode.getDstPSAppDEAction()??>
        <#assign targetEntity = delogicNode.getDstPSAppDataEntity() />
        <#assign deAction = delogicNode.getDstPSAppDEAction() />
        let result: any;
        const targetService:${srfclassname('${targetEntity.getCodeName()}')}Service = new ${srfclassname('${targetEntity.getCodeName()}')}Service();
        if (targetService['${deAction.getCodeName()}'] && targetService['${deAction.getCodeName()}'] instanceof Function) {
            result = await targetService['${deAction.getCodeName()}'](context,params, false);
        }
        if(result && result.status == 200){
            Object.assign(params,result.data);
            <@executeNext delogicNode />
        }
        </#if>
    }
    <#-- 准备参数节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "PREPAREPARAM">
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // 准备参数节点
        <@setParam delogicNode />
        <@executeNext delogicNode />
    }
    <#-- 开始流程节点 -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "STARTWF">
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // 开始流程节点
        return params;
    }
    <#-- 异常捕获节点  -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "THROWEXCEPTION">
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // 异常捕获节点
        return params;
    }
    <#-- 前端插件  -->
    <#elseif delogicNode.getLogicNodeType()?? && delogicNode.getLogicNodeType() == "PFPLUGIN">
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // 前端插件
        return params;
    }
    <#else>
    /**
    * ${delogicNode.getName()}
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async execute${delogicNode.codeName}(context:any,params:any,isloading:boolean){
        // ${delogicNode.getLogicNodeType()}暂未支持
        console.log("${delogicNode.getLogicNodeType()}暂未支持");
        return params;
    }
    </#if>
    </#list>
</#if>


}